/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteStub;
import java.rmi.server.Unreferenced;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.SequenceEntry;
import sun.rmi.transport.UnreferencedObj;
import sun.rmi.transport.WeakRef;

public final class Target {
    private boolean permanent = false;
    private WeakRef weakImpl;
    private Dispatcher disp;
    private RemoteStub stub;
    private Vector refSet = new Vector();
    private Hashtable sequenceTable = new Hashtable(5);

    public Target(Remote remote, Dispatcher dispatcher, RemoteStub remoteStub) {
        this.weakImpl = new WeakRef(remote);
        this.disp = dispatcher;
        this.stub = remoteStub;
    }

    public RemoteStub getStub() {
        return this.stub;
    }

    WeakRef getWeakImpl() {
        return this.weakImpl;
    }

    Dispatcher getDispatcher() {
        return this.disp;
    }

    synchronized Remote getImpl() {
        return (Remote)this.weakImpl.get();
    }

    boolean isPermanent() {
        return this.permanent;
    }

    synchronized void pinImpl() {
        this.weakImpl.pin();
    }

    synchronized void unpinImpl() {
        if (!this.permanent && this.refSet.isEmpty()) {
            this.weakImpl.unpin();
        }
    }

    public synchronized void setPermanent(boolean bl) {
        this.permanent = bl;
        if (this.permanent) {
            this.pinImpl();
            return;
        }
        this.unpinImpl();
    }

    synchronized void referenced(long l, VMID vMID) {
        SequenceEntry sequenceEntry = (SequenceEntry)this.sequenceTable.get(vMID);
        if (sequenceEntry == null) {
            this.sequenceTable.put(vMID, new SequenceEntry(l));
        } else if (sequenceEntry.sequenceNum < l) {
            sequenceEntry.update(l);
        } else {
            return;
        }
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("Target.referenced: add to dirty set: " + vMID);
        }
        if (this.refSet.contains(vMID)) {
            return;
        }
        this.refSet.addElement(vMID);
        DGCImpl.getDGCImpl().registerTarget(vMID, this);
    }

    synchronized void unreferenced(long l, VMID vMID, boolean bl) {
        SequenceEntry sequenceEntry = (SequenceEntry)this.sequenceTable.get(vMID);
        if (sequenceEntry == null || sequenceEntry.sequenceNum > l) {
            return;
        }
        if (bl) {
            sequenceEntry.retain(l);
        } else if (!sequenceEntry.keep) {
            this.sequenceTable.remove(vMID);
        }
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("Target.unreferenced: remove from dirty set: " + vMID);
        }
        this.refSetRemove(vMID);
    }

    private synchronized void refSetRemove(VMID vMID) {
        DGCImpl.getDGCImpl().unregisterTarget(vMID, this);
        if (this.refSet.removeElement(vMID) && this.refSet.isEmpty()) {
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("Target.unreferenced: reference set is empty: target = " + this);
            }
            this.unpinImpl();
            Remote remote = this.getImpl();
            if (remote instanceof Unreferenced) {
                new UnreferencedObj((Unreferenced)((Object)remote));
            }
        }
    }

    boolean isEmpty() {
        return this.refSet.isEmpty();
    }

    public synchronized void vmidDead(VMID vMID) {
        if (DGCImpl.logLevel >= 10) {
            LogStream.log("dgc").println("Target.notify: removing endpoint " + vMID + " from reference set");
        }
        this.sequenceTable.remove(vMID);
        this.refSetRemove(vMID);
    }
}

